// Demo app for TeraFAST C API.  
// It reads data from the device and prints a crude map to the console using  ASCII characters.

#define WIN32_LEAN_AND_MEAN

#include "libterafast.h"

#include <stdlib.h>
#include <conio.h>

int count = 0;

const char *  message = "You need console size at least %dx%d to see the output properly.\n\nPress any key to continue.\n";

const char *  help = "Intensity scale: .oO*\t%s%s\n"
"Press\n\t'1'-'9' to set rate\n\t"
"'+'/'-' to change rate\n\t"
"'<'/'>' to change frame length\n\t"
"'B' to record background\n\t"
"'N' to record normalization\n\t"
"'d' to select default nomalization\n\t"
"'r' to select recorded normalization\n\t"
"'f' to switch difference mode on and off\n\t"
"'s' to switch external sync mode on and off\n\t"
"'e' to switch between falling/rising edge in the external sync mode\n\t"
"ESC to quit.\n";

int pt(double p){
	if (p == 0){
		count = 0;
		return 0;
	}
	if (p * 100 >= count) {
		printf("%3d%% ", (int)(p * 100));
		count += 5;
	}
	if (count > 100)
		count =0;
	return 0;
}

int main(int argc, char* argv[])
{	
	TF_RES res = TF_OK;
	TF_DATA buf;
	TF_ELEMENT x;
	char * s;
	int offset, s_size;
	int i;
	int diff, sync, edge;
	char ch,px;
	int timeout;
	
	
	res = tfInit();
	if (res) {
		printf("Device initialization failed, code %d",res);
		return res;
	}

	timeout = 300; //ms

	diff = 0;
	tfSetDifference(diff);
	sync = 0;
	tfSetExternalSync(sync);
	edge = 0;
	tfSetEdge(edge);
	
	buf = (TF_DATA) malloc(dataLength*sizeof(TF_ELEMENT));

	s_size = sizeof(char) * 2 * dataLength + frameSize + 200;
	s = (char*)malloc(s_size);
	
	res = tfStart();
	printf(message, frameSize+2, frameLength + 12);
	_getch();
	i = 0;
	for (ch = 0; ch != 27; ) {
		

		if (_kbhit()){
			ch = _getch();
			switch (ch){
			case '1': tfSetRate(20); break;
			case '2':  tfSetRate(50); break;
			case '3':  tfSetRate(100); break;
			case '4':  tfSetRate(200); break;
			case '5':  tfSetRate(500); break;
			case '6':  tfSetRate(1000); break;
			case '7':  tfSetRate(2000); break;
			case '8':  tfSetRate(5000); break;
			case '9':  tfSetRate(10000); break;
			case'+': tfSetRate(tfGetRate() * 2); break;
			case'-': tfSetRate(tfGetRate() / 2); break;
			case'<':
			case ',':{
				if ((int)(frameLength / 2)  > 0) {
					tfStop();
					if (tfSetFrameLength((int)(frameLength / 2)) == TF_OK){
						free(buf);
						buf = (TF_DATA)malloc(dataLength*sizeof(TF_ELEMENT));
						s_size = sizeof(char) * 2 * dataLength + frameSize + 200;
						free(s);
						s = (char*)malloc(s_size);
					}
					tfStart();

				}
			} break;
			case'>':
			case '.':{
				if (frameLength * 2 < 1024) {
					tfStop();
					if (tfSetFrameLength(frameLength * 2) == TF_OK) {
						free(buf);
						buf = (TF_DATA)malloc(dataLength*sizeof(TF_ELEMENT));
						s_size = sizeof(char) * 2 * dataLength + frameSize + 200;
						free(s);
						s = (char*)malloc(s_size);
					}
					tfStart();
					
				}
			} break;
			case 'N': {printf("\nPercents done:"); tfRecordNormalization(&pt); }break;
			case 'B': {printf("\nPercents done:"); tfRecordBackground(&pt);	}break;
			case 'd': {tfSelectNorm(0); printf("Default normalization selected.\n"); } break;
			case 'r': {tfSelectNorm(1); printf("Recorded normalization selected.\n");} break;
			case 'f': {diff = 1 - diff; tfSetDifference(diff); 
				if (diff )
					printf("Difference mode is now ON.\n"); 
				else
					printf("Difference mode is now OFF.\n");
			} break;
			case 's': {sync = 1 - sync; tfSetExternalSync(sync);
				if (sync)
					printf("External sync mode is now ON.\n");
				else
					printf("External sync mode is now OFF.\n");
			} break;
			case 'e': {edge = 1 - edge; tfSetEdge(edge);
				if (edge)
					printf("Sync to FALLING edge.\n");
				else
					printf("Sync to RISING edge.\n");
			} break;
			default:;
			}
			
		}
		res = tfRead_T(buf, timeout);
//		res = tfRead(buf);
		if (res == TF_TIMEOUT) {
			continue;
		}
		else if (res != TF_OK) {
			printf("Error reading data.\n");
			break;
		}

		offset = sprintf_s(s, s_size, "[%4.0f lines/sec]%5d:\n", tfGetRate(), i++);
		for (int j = 0; j < frameLength; j++) {
			offset += sprintf_s(s + offset, s_size - offset, "|");
			for (int k = 0; k < frameSize; k++) {
				x = buf[k + j * frameSize];
				if (x < TF_MAX_VALUE / 1000)
					px = ' ';
				else if (x < TF_MAX_VALUE / 4)
					px = '.';
				else if (x < TF_MAX_VALUE / 2)
					px = 'o';
				else if (x < TF_MAX_VALUE / 4 * 3)
					px = 'O';
				else
					px = '*';
				offset += sprintf_s(s + offset, s_size - offset, "%c", px);
			}
			offset += sprintf_s(s + offset, s_size - offset, "|\n");
		}
		system("cls");

		printf("%s", s);
		printf(help, diff ? "Difference mode. " : "", sync ? (edge ? "External sync, falling. " : "External sync, rising. ") : "");
		i = 0;
	}




	
	res = tfStop();
	res = tfClose();
	free(buf);
	free(s);
	return res;
}

